
typedef struct {
  unsigned char commands[96];
  unsigned char commands_len;
  unsigned char responses[256];
  unsigned long resp_bits, resp_offset;
  struct usb_dev_handle* handle;
} jtag_commands;

int jtag_init(jtag_commands* buf, struct usb_dev_handle* handle, unsigned char tdi_io, unsigned char tms_io, unsigned char tck_io, unsigned char tdo_io, unsigned char delay);
void jtag_reinit(jtag_commands* buf);
int jtag_deinit(jtag_commands* buf);

int jtag_run_commands(jtag_commands* buf);
int jtag_get_response(jtag_commands* buf, unsigned char* to_here, unsigned long num_bits);

// TDI, TMS, TDI, TMS, ...
int jtag_send_data(jtag_commands* buf, unsigned char* two_bit_data, unsigned long num_bit_pairs, unsigned char read);
int jtag_send_data_dir(jtag_commands* buf, unsigned char two_bit_data, unsigned long num_bit_pairs, unsigned char read);

int jtag_shift_bits(jtag_commands* buf, unsigned char* data, unsigned long num_bits, unsigned char final, unsigned char read);
int jtag_shift_bits_dir(jtag_commands* buf, unsigned char data, unsigned long num_bits, unsigned char final, unsigned char read);
int jtag_shift_zeros(jtag_commands* buf, unsigned long num_bits, unsigned char final, unsigned char read);
int jtag_shift_ones(jtag_commands* buf, unsigned long num_bits, unsigned char final, unsigned char read);

int jtag_reset_TAP(jtag_commands* buf);
int jtag_shift_TMS(jtag_commands* buf, unsigned char data, unsigned char num_bits);
int jtag_RESET_to_IDLE(jtag_commands* buf);
int jtag_IDLE_to_SHIFT_DR(jtag_commands* buf);
int jtag_IDLE_to_SHIFT_IR(jtag_commands* buf);
int jtag_EXIT_IR_to_SHIFT_IR_via_UPDATE_IR(jtag_commands* buf);
int jtag_EXIT_IR_to_SHIFT_DR_via_UPDATE_IR(jtag_commands* buf);
int jtag_EXIT_IR_to_SHIFT_IR_direct(jtag_commands* buf);
int jtag_EXIT_DR_to_SHIFT_DR_via_UPDATE_DR(jtag_commands* buf);
int jtag_EXIT_DR_to_SHIFT_IR_via_UPDATE_DR(jtag_commands* buf);
int jtag_EXIT_DR_to_SHIFT_DR_direct(jtag_commands* buf);
//int jtag_go_to_shift_dr(jtag_commands* buf);
//int jtag_go_to_shift_ir(jtag_commands* buf);
